/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.features;

import com.mojang.serialization.Codec;
import com.slomaxonical.architectspalette.features.CrystalClusterConfig;
import com.slomaxonical.architectspalette.registry.APTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class CrystalClusterFeature
extends class_3031<CrystalClusterConfig> {
    public CrystalClusterFeature(Codec<CrystalClusterConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<CrystalClusterConfig> context) {
        if (!context.method_33652().method_22347(context.method_33655())) {
            return false;
        }
        if (((CrystalClusterConfig)context.method_33656()).hanging() ? context.method_33652().method_22347(context.method_33655().method_10084()) : context.method_33652().method_22347(context.method_33655().method_10074())) {
            return false;
        }
        CrystalClusterConfig config = (CrystalClusterConfig)context.method_33656();
        Random random = context.method_33654();
        class_1160 shelfAngle = class_1160.field_20702.method_23850();
        shelfAngle.method_19262(class_1160.field_20705.method_23214(random.nextFloat(360.0f)));
        class_1160 formationAngle = shelfAngle.method_23850();
        formationAngle.method_19262(class_1160.field_20705.method_23214(CrystalClusterFeature.fRandomRange(random, -15.0f, 15.0f) + 90.0f));
        class_1160 placePos = new class_1160((float)context.method_33655().method_10263(), (float)context.method_33655().method_10264(), (float)context.method_33655().method_10260());
        ArrayList<class_2338> posList = new ArrayList<class_2338>(List.of());
        int shelves = CrystalClusterFeature.iRandomRange(random, 4, 7);
        for (int i = 0; i < shelves; ++i) {
            float scale = ((float)i + 1.0f) / (float)shelves;
            int pillars = CrystalClusterFeature.iRandomRange(random, 1, 7);
            CrystalClusterFeature.placeShelf(new class_2338((double)placePos.method_4943(), (double)placePos.method_4945(), (double)placePos.method_4947()), pillars, shelfAngle, scale, context, posList);
            formationAngle.method_4952();
            formationAngle.method_4942(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.0f));
            placePos.method_23846(formationAngle);
        }
        for (class_2338 pos : posList) {
            CrystalClusterFeature.tryPlaceExtrusion(pos, context.method_33652(), config.extrusionState(), config.crystalState().method_26204(), config.hanging() ? 1 : -1, random);
        }
        return true;
    }

    private static void placeShelf(class_2338 startPos, int crystals, class_1160 shelfAngle, float shelfScale, class_5821<CrystalClusterConfig> context, List<class_2338> crystalList) {
        Random random = context.method_33654();
        CrystalClusterConfig config = (CrystalClusterConfig)context.method_33656();
        class_5281 world = context.method_33652();
        int flip = config.hanging() ? 1 : -1;
        class_1160 placePos = new class_1160((float)startPos.method_10263(), (float)startPos.method_10264(), (float)startPos.method_10260());
        placePos.method_4948(0.0f, (float)(-2 * flip), 0.0f);
        for (int i = 0; i < crystals; ++i) {
            class_1160 offset = shelfAngle.method_23850();
            offset.method_4942(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.5f));
            placePos.method_23846(offset);
            int pillarLength = config.minLength() + random.nextInt((int)Math.floor((float)(config.maxLength() - config.minLength()) * shelfScale) + 1);
            CrystalClusterFeature.placePillar(new class_2338.class_2339((double)placePos.method_4943(), (double)placePos.method_4945(), (double)placePos.method_4947()), pillarLength, world, context, flip, crystalList);
            if (pillarLength <= (config.maxLength() - config.minLength()) / 2 || !random.nextBoolean()) continue;
            class_2338.class_2339 pos = new class_2338.class_2339((double)(placePos.method_4943() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.method_4945() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.method_4947() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)));
            CrystalClusterFeature.placePillar(pos, pillarLength / 2, world, context, flip, crystalList);
        }
    }

    private static void placePillar(class_2338.class_2339 placePos, int length, class_5281 world, class_5821<CrystalClusterConfig> context, int flip, List<class_2338> crystalList) {
        CrystalClusterConfig config = (CrystalClusterConfig)context.method_33656();
        int tries = 10;
        while (CrystalClusterFeature.canReplaceAt(world, (class_2338)placePos)) {
            placePos.method_33098(placePos.method_10264() + flip);
            if (world.method_8320((class_2338)placePos).method_27852(class_2246.field_10164)) {
                return;
            }
            if (tries-- != 0) continue;
            return;
        }
        tries = 5;
        while (!CrystalClusterFeature.canReplaceAt(world, (class_2338)placePos)) {
            placePos.method_33098(placePos.method_10264() - flip);
            if (tries-- != 0) continue;
            return;
        }
        boolean doExtrusion = true;
        while (--length >= 0) {
            if (!CrystalClusterFeature.canReplaceAt(world, (class_2338)placePos)) {
                return;
            }
            if (doExtrusion) {
                crystalList.add(placePos.method_10062());
                doExtrusion = false;
            }
            world.method_8652((class_2338)placePos, config.crystalState(), 2);
            placePos.method_33098(placePos.method_10264() - flip);
        }
    }

    private static void tryPlaceExtrusion(class_2338 startPos, class_5281 world, class_2680 placeState, class_2248 avoidBlock, int flip, Random random) {
        for (class_2350 dir : class_2350.values()) {
            if (dir.method_10166() == class_2350.class_2351.field_11052 || random.nextInt(3) != 1) continue;
            class_2338 pos = startPos.method_10079(dir, 1);
            while (world.method_8320(pos).method_27852(placeState.method_26204()) && Math.abs(startPos.method_10264() - pos.method_10264()) <= 4) {
                pos = pos.method_10087(flip);
            }
            class_2338 above = pos.method_10084();
            class_2338 below = pos.method_10074();
            if (!(CrystalClusterFeature.canReplaceAt(world, above) ^ CrystalClusterFeature.canReplaceAt(world, below)) || world.method_8320(above).method_27852(avoidBlock) || world.method_8320(below).method_27852(avoidBlock)) continue;
            for (int i = CrystalClusterFeature.iRandomRange(random, 1, 2); i > 0 && CrystalClusterFeature.canReplaceAt(world, pos); --i) {
                world.method_8652(pos, placeState, 2);
                pos = pos.method_10087(flip);
            }
        }
    }

    private static int iRandomRange(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }

    private static float fRandomRange(Random random, float min, float max) {
        return min + random.nextFloat(max - min);
    }

    private static boolean canReplaceAt(class_5281 level, class_2338 pos) {
        return CrystalClusterFeature.canReplace(level.method_8320(pos));
    }

    private static boolean canReplace(class_2680 state) {
        return state.method_26215() || state.method_26207().method_15800() || state.method_26164(APTags.CRYSTAL_REPLACEABLE);
    }
}

